REBOL [
	subject: "objet XML"
	author: "Olivier Auverlot"
	version: 1.1
]

xml: make object! [

	document: make block! []
	code-rebol: make block! []	

	node?: make logic! true
	path: make string! ""	
	element: make string! ""
	attr: make block! [] 
	text: make string! ""

	xml-language/Check-version: none

	read-document: function [ document-name ] [] [
		if error? try [
			document: copy parse-xml (read document-name)
			return true
		] [ return false ]
	]

	usable-item?: function [ value ] [] [
		if block? value [ value: first value ]
		(length? (trim value)) > 0 
	]

	previous-node: does [
		if found? find path "/" [
			path: copy/part path ((index? find/last path "/") - 1)
		]
	]

	run-code: does [ do code-rebol ]

	explore: function [ data ] [ tag value param item next-node ] [
		tag: copy first data
		value: copy third data
		either none? (second data) [ param: none ] [ param: copy second data ]

		element: copy tag

		either ((length? path) > 0) [
			append path (reduce [ "/" tag ])
		] [ path: copy tag ]

		forall value [
			if usable-item? (first value) [
				item: copy first value
				either none? param [ attr: none ] [ attr: copy param ]
				either (block? item) [
					; lment pre 		
					text: none
					node?: true
					run-code
					forall value [ 
						next-node: first value
						if usable-item? next-node [ 
							explore next-node
						]
					] 
				] [ 
					; lment fils
					text: copy item
					node?: false
					run-code			
				]	
				previous-node		
			]
		]
	]

	execute: function [ code ] [] [
		code-rebol: copy code
		explore (first third document)
	]
]

